within IFV_Lib.RoadLoad;
model ParamRoadLoad

  Modelica.Mechanics.Rotational.Interfaces.Flange_a flange
    annotation (extent=[-88,-48; -68,-28]);
  Modelica.Mechanics.Rotational.Components.Damper damper(d=d)
    annotation (extent=[-26,-50; -6,-30]);
  Modelica.Mechanics.Rotational.Components.Fixed fixed annotation (extent=[20,-50; 40,-30]);
  Modelica.Mechanics.Rotational.Components.Inertia inertia(J=J)
    annotation (Placement(transformation(extent={{-58,-48},{-38,-28}})));
  Modelica.Blocks.Interfaces.RealOutput Speed annotation (extent=[-100,46; -60,86],
      Placement(transformation(extent={{60,0},{100,40}}), iconTransformation(
          extent={{60,0},{100,40}})));
  parameter Real wheel_radius(start = 0.3);
  parameter Real d(start = 0.4);
  parameter Real J(start = 0.1);
equation
  Speed = der(flange.phi) * wheel_radius * (3600 * 3.2808399) / 5280;
  connect(damper.flange_b, fixed.flange) annotation (points=[-6,-40; 30,-40],
      style(
      color=0,
      rgbcolor={0,0,0},
      smooth=0));
  connect(inertia.flange_a, flange) annotation (Line(
      points={{-58,-38},{-78,-38}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(inertia.flange_b, damper.flange_a) annotation (Line(
      points={{-38,-38},{-32,-38},{-32,-40},{-26,-40}},
      color={0,0,0},
      smooth=Smooth.None));
  annotation (uses(Modelica(version="3.2")), Icon(graphics),
    Diagram(graphics),
              uses(Modelica(version="3.2")), Icon(graphics));
end ParamRoadLoad;
